<?php
/**
 * SendWhatsAppApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Utils;
use GuzzleHttp\RequestOptions;
use Infobip\ApiException;
use Infobip\Configuration;
use Infobip\HeaderSelector;
use Infobip\ObjectSerializer;

/**
 * SendWhatsAppApi Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */
class SendWhatsAppApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
    * @param ClientInterface $client
    * @param Configuration   $config
    * @param HeaderSelector  $selector
    */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation sendWhatsAppAudioMessage
     *
     * Send WhatsApp audio message
     *
     * @param  \Infobip\Model\WhatsAppAudioMessage $whatsAppAudioMessage whatsAppAudioMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppAudioMessage($whatsAppAudioMessage)
    {
        list($response) = $this->sendWhatsAppAudioMessageWithHttpInfo($whatsAppAudioMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppAudioMessageWithHttpInfo
     *
     * Send WhatsApp audio message
     *
     * @param  \Infobip\Model\WhatsAppAudioMessage $whatsAppAudioMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppAudioMessageWithHttpInfo($whatsAppAudioMessage)
    {
        $request = $this->sendWhatsAppAudioMessageRequest($whatsAppAudioMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppAudioMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppAudioMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppAudioMessageAsync
     *
     * Send WhatsApp audio message
     *
     * @param  \Infobip\Model\WhatsAppAudioMessage $whatsAppAudioMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppAudioMessageAsync($whatsAppAudioMessage)
    {
        return $this->sendWhatsAppAudioMessageAsyncWithHttpInfo($whatsAppAudioMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppAudioMessageAsyncWithHttpInfo
     *
     * Send WhatsApp audio message
     *
     * @param  \Infobip\Model\WhatsAppAudioMessage $whatsAppAudioMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppAudioMessageAsyncWithHttpInfo($whatsAppAudioMessage)
    {
        $request = $this->sendWhatsAppAudioMessageRequest($whatsAppAudioMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppAudioMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppAudioMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppAudioMessage'
     *
     * @param  \Infobip\Model\WhatsAppAudioMessage $whatsAppAudioMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppAudioMessageRequest($whatsAppAudioMessage)
    {
        // verify the required parameter 'whatsAppAudioMessage' is set
        if ($whatsAppAudioMessage === null || (is_array($whatsAppAudioMessage) && count($whatsAppAudioMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppAudioMessage when calling sendWhatsAppAudioMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/audio';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppAudioMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppAudioMessage));
            } else {
                $httpBody = $whatsAppAudioMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppAudioMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppAudioMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppAudioMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppAudioMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppContactMessage
     *
     * Send WhatsApp contact message
     *
     * @param  \Infobip\Model\WhatsAppContactsMessage $whatsAppContactsMessage whatsAppContactsMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppContactMessage($whatsAppContactsMessage)
    {
        list($response) = $this->sendWhatsAppContactMessageWithHttpInfo($whatsAppContactsMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppContactMessageWithHttpInfo
     *
     * Send WhatsApp contact message
     *
     * @param  \Infobip\Model\WhatsAppContactsMessage $whatsAppContactsMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppContactMessageWithHttpInfo($whatsAppContactsMessage)
    {
        $request = $this->sendWhatsAppContactMessageRequest($whatsAppContactsMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppContactMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppContactMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppContactMessageAsync
     *
     * Send WhatsApp contact message
     *
     * @param  \Infobip\Model\WhatsAppContactsMessage $whatsAppContactsMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppContactMessageAsync($whatsAppContactsMessage)
    {
        return $this->sendWhatsAppContactMessageAsyncWithHttpInfo($whatsAppContactsMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppContactMessageAsyncWithHttpInfo
     *
     * Send WhatsApp contact message
     *
     * @param  \Infobip\Model\WhatsAppContactsMessage $whatsAppContactsMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppContactMessageAsyncWithHttpInfo($whatsAppContactsMessage)
    {
        $request = $this->sendWhatsAppContactMessageRequest($whatsAppContactsMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppContactMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppContactMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppContactMessage'
     *
     * @param  \Infobip\Model\WhatsAppContactsMessage $whatsAppContactsMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppContactMessageRequest($whatsAppContactsMessage)
    {
        // verify the required parameter 'whatsAppContactsMessage' is set
        if ($whatsAppContactsMessage === null || (is_array($whatsAppContactsMessage) && count($whatsAppContactsMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppContactsMessage when calling sendWhatsAppContactMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/contact';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppContactsMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppContactsMessage));
            } else {
                $httpBody = $whatsAppContactsMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppContactMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppContactMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppContactMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppContactMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppDocumentMessage
     *
     * Send WhatsApp document message
     *
     * @param  \Infobip\Model\WhatsAppDocumentMessage $whatsAppDocumentMessage whatsAppDocumentMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppDocumentMessage($whatsAppDocumentMessage)
    {
        list($response) = $this->sendWhatsAppDocumentMessageWithHttpInfo($whatsAppDocumentMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppDocumentMessageWithHttpInfo
     *
     * Send WhatsApp document message
     *
     * @param  \Infobip\Model\WhatsAppDocumentMessage $whatsAppDocumentMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppDocumentMessageWithHttpInfo($whatsAppDocumentMessage)
    {
        $request = $this->sendWhatsAppDocumentMessageRequest($whatsAppDocumentMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppDocumentMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppDocumentMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppDocumentMessageAsync
     *
     * Send WhatsApp document message
     *
     * @param  \Infobip\Model\WhatsAppDocumentMessage $whatsAppDocumentMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppDocumentMessageAsync($whatsAppDocumentMessage)
    {
        return $this->sendWhatsAppDocumentMessageAsyncWithHttpInfo($whatsAppDocumentMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppDocumentMessageAsyncWithHttpInfo
     *
     * Send WhatsApp document message
     *
     * @param  \Infobip\Model\WhatsAppDocumentMessage $whatsAppDocumentMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppDocumentMessageAsyncWithHttpInfo($whatsAppDocumentMessage)
    {
        $request = $this->sendWhatsAppDocumentMessageRequest($whatsAppDocumentMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppDocumentMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppDocumentMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppDocumentMessage'
     *
     * @param  \Infobip\Model\WhatsAppDocumentMessage $whatsAppDocumentMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppDocumentMessageRequest($whatsAppDocumentMessage)
    {
        // verify the required parameter 'whatsAppDocumentMessage' is set
        if ($whatsAppDocumentMessage === null || (is_array($whatsAppDocumentMessage) && count($whatsAppDocumentMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppDocumentMessage when calling sendWhatsAppDocumentMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/document';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppDocumentMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppDocumentMessage));
            } else {
                $httpBody = $whatsAppDocumentMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppDocumentMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppDocumentMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppDocumentMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppDocumentMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppImageMessage
     *
     * Send WhatsApp image message
     *
     * @param  \Infobip\Model\WhatsAppImageMessage $whatsAppImageMessage whatsAppImageMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppImageMessage($whatsAppImageMessage)
    {
        list($response) = $this->sendWhatsAppImageMessageWithHttpInfo($whatsAppImageMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppImageMessageWithHttpInfo
     *
     * Send WhatsApp image message
     *
     * @param  \Infobip\Model\WhatsAppImageMessage $whatsAppImageMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppImageMessageWithHttpInfo($whatsAppImageMessage)
    {
        $request = $this->sendWhatsAppImageMessageRequest($whatsAppImageMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppImageMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppImageMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppImageMessageAsync
     *
     * Send WhatsApp image message
     *
     * @param  \Infobip\Model\WhatsAppImageMessage $whatsAppImageMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppImageMessageAsync($whatsAppImageMessage)
    {
        return $this->sendWhatsAppImageMessageAsyncWithHttpInfo($whatsAppImageMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppImageMessageAsyncWithHttpInfo
     *
     * Send WhatsApp image message
     *
     * @param  \Infobip\Model\WhatsAppImageMessage $whatsAppImageMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppImageMessageAsyncWithHttpInfo($whatsAppImageMessage)
    {
        $request = $this->sendWhatsAppImageMessageRequest($whatsAppImageMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppImageMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppImageMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppImageMessage'
     *
     * @param  \Infobip\Model\WhatsAppImageMessage $whatsAppImageMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppImageMessageRequest($whatsAppImageMessage)
    {
        // verify the required parameter 'whatsAppImageMessage' is set
        if ($whatsAppImageMessage === null || (is_array($whatsAppImageMessage) && count($whatsAppImageMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppImageMessage when calling sendWhatsAppImageMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/image';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppImageMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppImageMessage));
            } else {
                $httpBody = $whatsAppImageMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppImageMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppImageMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppImageMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppImageMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppInteractiveButtonsMessage
     *
     * Send WhatsApp interactive buttons message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveButtonsMessage $whatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppInteractiveButtonsMessage($whatsAppInteractiveButtonsMessage)
    {
        list($response) = $this->sendWhatsAppInteractiveButtonsMessageWithHttpInfo($whatsAppInteractiveButtonsMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppInteractiveButtonsMessageWithHttpInfo
     *
     * Send WhatsApp interactive buttons message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveButtonsMessage $whatsAppInteractiveButtonsMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppInteractiveButtonsMessageWithHttpInfo($whatsAppInteractiveButtonsMessage)
    {
        $request = $this->sendWhatsAppInteractiveButtonsMessageRequest($whatsAppInteractiveButtonsMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppInteractiveButtonsMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppInteractiveButtonsMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppInteractiveButtonsMessageAsync
     *
     * Send WhatsApp interactive buttons message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveButtonsMessage $whatsAppInteractiveButtonsMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppInteractiveButtonsMessageAsync($whatsAppInteractiveButtonsMessage)
    {
        return $this->sendWhatsAppInteractiveButtonsMessageAsyncWithHttpInfo($whatsAppInteractiveButtonsMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppInteractiveButtonsMessageAsyncWithHttpInfo
     *
     * Send WhatsApp interactive buttons message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveButtonsMessage $whatsAppInteractiveButtonsMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppInteractiveButtonsMessageAsyncWithHttpInfo($whatsAppInteractiveButtonsMessage)
    {
        $request = $this->sendWhatsAppInteractiveButtonsMessageRequest($whatsAppInteractiveButtonsMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppInteractiveButtonsMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppInteractiveButtonsMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppInteractiveButtonsMessage'
     *
     * @param  \Infobip\Model\WhatsAppInteractiveButtonsMessage $whatsAppInteractiveButtonsMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppInteractiveButtonsMessageRequest($whatsAppInteractiveButtonsMessage)
    {
        // verify the required parameter 'whatsAppInteractiveButtonsMessage' is set
        if ($whatsAppInteractiveButtonsMessage === null || (is_array($whatsAppInteractiveButtonsMessage) && count($whatsAppInteractiveButtonsMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppInteractiveButtonsMessage when calling sendWhatsAppInteractiveButtonsMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/interactive/buttons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppInteractiveButtonsMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppInteractiveButtonsMessage));
            } else {
                $httpBody = $whatsAppInteractiveButtonsMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppInteractiveButtonsMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppInteractiveButtonsMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppInteractiveButtonsMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppInteractiveButtonsMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppInteractiveListMessage
     *
     * Send WhatsApp interactive list message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveListMessage $whatsAppInteractiveListMessage whatsAppInteractiveListMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppInteractiveListMessage($whatsAppInteractiveListMessage)
    {
        list($response) = $this->sendWhatsAppInteractiveListMessageWithHttpInfo($whatsAppInteractiveListMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppInteractiveListMessageWithHttpInfo
     *
     * Send WhatsApp interactive list message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveListMessage $whatsAppInteractiveListMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppInteractiveListMessageWithHttpInfo($whatsAppInteractiveListMessage)
    {
        $request = $this->sendWhatsAppInteractiveListMessageRequest($whatsAppInteractiveListMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppInteractiveListMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppInteractiveListMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppInteractiveListMessageAsync
     *
     * Send WhatsApp interactive list message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveListMessage $whatsAppInteractiveListMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppInteractiveListMessageAsync($whatsAppInteractiveListMessage)
    {
        return $this->sendWhatsAppInteractiveListMessageAsyncWithHttpInfo($whatsAppInteractiveListMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppInteractiveListMessageAsyncWithHttpInfo
     *
     * Send WhatsApp interactive list message
     *
     * @param  \Infobip\Model\WhatsAppInteractiveListMessage $whatsAppInteractiveListMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppInteractiveListMessageAsyncWithHttpInfo($whatsAppInteractiveListMessage)
    {
        $request = $this->sendWhatsAppInteractiveListMessageRequest($whatsAppInteractiveListMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppInteractiveListMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppInteractiveListMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppInteractiveListMessage'
     *
     * @param  \Infobip\Model\WhatsAppInteractiveListMessage $whatsAppInteractiveListMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppInteractiveListMessageRequest($whatsAppInteractiveListMessage)
    {
        // verify the required parameter 'whatsAppInteractiveListMessage' is set
        if ($whatsAppInteractiveListMessage === null || (is_array($whatsAppInteractiveListMessage) && count($whatsAppInteractiveListMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppInteractiveListMessage when calling sendWhatsAppInteractiveListMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/interactive/list';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppInteractiveListMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppInteractiveListMessage));
            } else {
                $httpBody = $whatsAppInteractiveListMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppInteractiveListMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppInteractiveListMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppInteractiveListMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppInteractiveListMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppLocationMessage
     *
     * Send WhatsApp location message
     *
     * @param  \Infobip\Model\WhatsAppLocationMessage $whatsAppLocationMessage whatsAppLocationMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppLocationMessage($whatsAppLocationMessage)
    {
        list($response) = $this->sendWhatsAppLocationMessageWithHttpInfo($whatsAppLocationMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppLocationMessageWithHttpInfo
     *
     * Send WhatsApp location message
     *
     * @param  \Infobip\Model\WhatsAppLocationMessage $whatsAppLocationMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppLocationMessageWithHttpInfo($whatsAppLocationMessage)
    {
        $request = $this->sendWhatsAppLocationMessageRequest($whatsAppLocationMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppLocationMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppLocationMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppLocationMessageAsync
     *
     * Send WhatsApp location message
     *
     * @param  \Infobip\Model\WhatsAppLocationMessage $whatsAppLocationMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppLocationMessageAsync($whatsAppLocationMessage)
    {
        return $this->sendWhatsAppLocationMessageAsyncWithHttpInfo($whatsAppLocationMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppLocationMessageAsyncWithHttpInfo
     *
     * Send WhatsApp location message
     *
     * @param  \Infobip\Model\WhatsAppLocationMessage $whatsAppLocationMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppLocationMessageAsyncWithHttpInfo($whatsAppLocationMessage)
    {
        $request = $this->sendWhatsAppLocationMessageRequest($whatsAppLocationMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppLocationMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppLocationMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppLocationMessage'
     *
     * @param  \Infobip\Model\WhatsAppLocationMessage $whatsAppLocationMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppLocationMessageRequest($whatsAppLocationMessage)
    {
        // verify the required parameter 'whatsAppLocationMessage' is set
        if ($whatsAppLocationMessage === null || (is_array($whatsAppLocationMessage) && count($whatsAppLocationMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppLocationMessage when calling sendWhatsAppLocationMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/location';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppLocationMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppLocationMessage));
            } else {
                $httpBody = $whatsAppLocationMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppLocationMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppLocationMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppLocationMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppLocationMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppStickerMessage
     *
     * Send WhatsApp sticker message
     *
     * @param  \Infobip\Model\WhatsAppStickerMessage $whatsAppStickerMessage whatsAppStickerMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppStickerMessage($whatsAppStickerMessage)
    {
        list($response) = $this->sendWhatsAppStickerMessageWithHttpInfo($whatsAppStickerMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppStickerMessageWithHttpInfo
     *
     * Send WhatsApp sticker message
     *
     * @param  \Infobip\Model\WhatsAppStickerMessage $whatsAppStickerMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppStickerMessageWithHttpInfo($whatsAppStickerMessage)
    {
        $request = $this->sendWhatsAppStickerMessageRequest($whatsAppStickerMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppStickerMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppStickerMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppStickerMessageAsync
     *
     * Send WhatsApp sticker message
     *
     * @param  \Infobip\Model\WhatsAppStickerMessage $whatsAppStickerMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppStickerMessageAsync($whatsAppStickerMessage)
    {
        return $this->sendWhatsAppStickerMessageAsyncWithHttpInfo($whatsAppStickerMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppStickerMessageAsyncWithHttpInfo
     *
     * Send WhatsApp sticker message
     *
     * @param  \Infobip\Model\WhatsAppStickerMessage $whatsAppStickerMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppStickerMessageAsyncWithHttpInfo($whatsAppStickerMessage)
    {
        $request = $this->sendWhatsAppStickerMessageRequest($whatsAppStickerMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppStickerMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppStickerMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppStickerMessage'
     *
     * @param  \Infobip\Model\WhatsAppStickerMessage $whatsAppStickerMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppStickerMessageRequest($whatsAppStickerMessage)
    {
        // verify the required parameter 'whatsAppStickerMessage' is set
        if ($whatsAppStickerMessage === null || (is_array($whatsAppStickerMessage) && count($whatsAppStickerMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppStickerMessage when calling sendWhatsAppStickerMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/sticker';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppStickerMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppStickerMessage));
            } else {
                $httpBody = $whatsAppStickerMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppStickerMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppStickerMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppStickerMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppStickerMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppTemplateMessage
     *
     * Send WhatsApp template message
     *
     * @param  \Infobip\Model\WhatsAppBulkMessage $whatsAppBulkMessage whatsAppBulkMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppBulkMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppTemplateMessage($whatsAppBulkMessage)
    {
        list($response) = $this->sendWhatsAppTemplateMessageWithHttpInfo($whatsAppBulkMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppTemplateMessageWithHttpInfo
     *
     * Send WhatsApp template message
     *
     * @param  \Infobip\Model\WhatsAppBulkMessage $whatsAppBulkMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppBulkMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppTemplateMessageWithHttpInfo($whatsAppBulkMessage)
    {
        $request = $this->sendWhatsAppTemplateMessageRequest($whatsAppBulkMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppTemplateMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppTemplateMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppTemplateMessageAsync
     *
     * Send WhatsApp template message
     *
     * @param  \Infobip\Model\WhatsAppBulkMessage $whatsAppBulkMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppTemplateMessageAsync($whatsAppBulkMessage)
    {
        return $this->sendWhatsAppTemplateMessageAsyncWithHttpInfo($whatsAppBulkMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppTemplateMessageAsyncWithHttpInfo
     *
     * Send WhatsApp template message
     *
     * @param  \Infobip\Model\WhatsAppBulkMessage $whatsAppBulkMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppTemplateMessageAsyncWithHttpInfo($whatsAppBulkMessage)
    {
        $request = $this->sendWhatsAppTemplateMessageRequest($whatsAppBulkMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppTemplateMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppTemplateMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppTemplateMessage'
     *
     * @param  \Infobip\Model\WhatsAppBulkMessage $whatsAppBulkMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppTemplateMessageRequest($whatsAppBulkMessage)
    {
        // verify the required parameter 'whatsAppBulkMessage' is set
        if ($whatsAppBulkMessage === null || (is_array($whatsAppBulkMessage) && count($whatsAppBulkMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppBulkMessage when calling sendWhatsAppTemplateMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/template';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppBulkMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppBulkMessage));
            } else {
                $httpBody = $whatsAppBulkMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppTemplateMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppBulkMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppTemplateMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppBulkMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppTemplateMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppTemplateMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppTextMessage
     *
     * Send WhatsApp text message
     *
     * @param  \Infobip\Model\WhatsAppTextMessage $whatsAppTextMessage whatsAppTextMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppTextMessage($whatsAppTextMessage)
    {
        list($response) = $this->sendWhatsAppTextMessageWithHttpInfo($whatsAppTextMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppTextMessageWithHttpInfo
     *
     * Send WhatsApp text message
     *
     * @param  \Infobip\Model\WhatsAppTextMessage $whatsAppTextMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppTextMessageWithHttpInfo($whatsAppTextMessage)
    {
        $request = $this->sendWhatsAppTextMessageRequest($whatsAppTextMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppTextMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppTextMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppTextMessageAsync
     *
     * Send WhatsApp text message
     *
     * @param  \Infobip\Model\WhatsAppTextMessage $whatsAppTextMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppTextMessageAsync($whatsAppTextMessage)
    {
        return $this->sendWhatsAppTextMessageAsyncWithHttpInfo($whatsAppTextMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppTextMessageAsyncWithHttpInfo
     *
     * Send WhatsApp text message
     *
     * @param  \Infobip\Model\WhatsAppTextMessage $whatsAppTextMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppTextMessageAsyncWithHttpInfo($whatsAppTextMessage)
    {
        $request = $this->sendWhatsAppTextMessageRequest($whatsAppTextMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppTextMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppTextMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppTextMessage'
     *
     * @param  \Infobip\Model\WhatsAppTextMessage $whatsAppTextMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppTextMessageRequest($whatsAppTextMessage)
    {
        // verify the required parameter 'whatsAppTextMessage' is set
        if ($whatsAppTextMessage === null || (is_array($whatsAppTextMessage) && count($whatsAppTextMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppTextMessage when calling sendWhatsAppTextMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/text';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppTextMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppTextMessage));
            } else {
                $httpBody = $whatsAppTextMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppTextMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppTextMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppTextMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppTextMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendWhatsAppVideoMessage
     *
     * Send WhatsApp video message
     *
     * @param  \Infobip\Model\WhatsAppVideoMessage $whatsAppVideoMessage whatsAppVideoMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function sendWhatsAppVideoMessage($whatsAppVideoMessage)
    {
        list($response) = $this->sendWhatsAppVideoMessageWithHttpInfo($whatsAppVideoMessage);
        return $response;
    }

    /**
     * Operation sendWhatsAppVideoMessageWithHttpInfo
     *
     * Send WhatsApp video message
     *
     * @param  \Infobip\Model\WhatsAppVideoMessage $whatsAppVideoMessage (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendWhatsAppVideoMessageWithHttpInfo($whatsAppVideoMessage)
    {
        $request = $this->sendWhatsAppVideoMessageRequest($whatsAppVideoMessage);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendWhatsAppVideoMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendWhatsAppVideoMessageApiException($e);
        }
    }

    /**
     * Operation sendWhatsAppVideoMessageAsync
     *
     * Send WhatsApp video message
     *
     * @param  \Infobip\Model\WhatsAppVideoMessage $whatsAppVideoMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppVideoMessageAsync($whatsAppVideoMessage)
    {
        return $this->sendWhatsAppVideoMessageAsyncWithHttpInfo($whatsAppVideoMessage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendWhatsAppVideoMessageAsyncWithHttpInfo
     *
     * Send WhatsApp video message
     *
     * @param  \Infobip\Model\WhatsAppVideoMessage $whatsAppVideoMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendWhatsAppVideoMessageAsyncWithHttpInfo($whatsAppVideoMessage)
    {
        $request = $this->sendWhatsAppVideoMessageRequest($whatsAppVideoMessage);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendWhatsAppVideoMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendWhatsAppVideoMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendWhatsAppVideoMessage'
     *
     * @param  \Infobip\Model\WhatsAppVideoMessage $whatsAppVideoMessage (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendWhatsAppVideoMessageRequest($whatsAppVideoMessage)
    {
        // verify the required parameter 'whatsAppVideoMessage' is set
        if ($whatsAppVideoMessage === null || (is_array($whatsAppVideoMessage) && count($whatsAppVideoMessage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppVideoMessage when calling sendWhatsAppVideoMessage'
            );
        }

        $resourcePath = '/whatsapp/1/message/video';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppVideoMessage)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppVideoMessage));
            } else {
                $httpBody = $whatsAppVideoMessage;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendWhatsAppVideoMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppSingleMessageInfo|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendWhatsAppVideoMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppSingleMessageInfo';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendWhatsAppVideoMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendWhatsAppVideoMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
